#include "VOS_API/DX_VOS_Sem.h"
DxStatus DX_VOS_SemCreate (DxVosSem  *aSemId, DxUint_t  aInitialValue, const DxChar* semName)
{
	/* semName is deliberately ignored because in Windows OS calling CreateSemaphore 
	   with the name of existing semaphore returns a handle to the existing semaphore
	   instead of creating a new one */ 
	semName = semName;
	DX_ASSERT_PARAM(aSemId != DX_NULL);

	*aSemId = (DxVosSem)1;
	DX_RETURN(DX_SUCCESS);
}

DxStatus DX_VOS_SemDelete (DxVosSem  aSemId)
{
    return DX_VOS_SemDestroy(&aSemId);
}

DxStatus DX_VOS_SemDestroy (DxVosSem*  aSemId)
{
    if (aSemId == DX_NULL || *aSemId == DX_NULL)
		DX_RETURN(DX_SUCCESS);

    *aSemId = DX_NULL;
	DX_RETURN(DX_SUCCESS);
}

DxStatus DX_VOS_SemWait(DxVosSem aSemId, DxUint32_t aTimeout)
{
	DX_RETURN(DX_SUCCESS);
}

DxStatus DX_VOS_SemGive(DxVosSem aSemId)
{
	DX_RETURN(DX_SUCCESS);
}
